---
title: Universal Path gateway · Cloudflare Web3 docs
description: When you set up a Universal Path gateway — a gateway without a
  DNSLink record — you are creating an unrestricted gateway that allows users to
  access any content hosted on the IPFS network.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/web3/ipfs-gateway/concepts/universal-gateway/
  md: https://developers.cloudflare.com/web3/ipfs-gateway/concepts/universal-gateway/index.md
---

When you set up a Universal Path gateway — a gateway without a *DNSLink* record — you are creating an unrestricted gateway that allows users to access any content hosted on the IPFS network.

This differs from a [restricted gateway](https://developers.cloudflare.com/web3/ipfs-gateway/concepts/dnslink/), which restricts the gateway to a particular piece of content (either a specific Content Identifier (CID) or an Interplanetary Name Service (IPNS) hostname).

## How is it used with Cloudflare?

You can add a Universal Path gateway just as you would [create any gateway](https://developers.cloudflare.com/web3/how-to/manage-gateways/).

Likely, you will also want to add items to the [gateway blocklist](https://developers.cloudflare.com/web3/how-to/manage-gateways/#update-blocklist), which allows you to block content access through the Universal Path gateway for one or more:

* CIDs (`QmPZ9gcCEpqKTo6aq61g2nXGUhM4iCL3ewB6LDXZCtioEB`)
* IPFS content (`/ipfs/QmYwAPJzv5CZsnA625s3Xf2nemtYgPpHdWEz79ojWnPbdG/readme`)
* IPNS content paths (`/ipns/example.com`)

Note

This feature is limited to specific plans. For more detail, refer to [Limits](https://developers.cloudflare.com/web3/reference/limits/).
