---
title: FAQ · Cloudflare Waiting Room docs
description: Below you will find answers to our most commonly asked questions
  about the Waiting Room.
lastUpdated: 2025-06-03T16:48:15.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waiting-room/troubleshooting/
  md: https://developers.cloudflare.com/waiting-room/troubleshooting/index.md
---

Below you will find answers to our most commonly asked questions about the Waiting Room.

* [Configuration](#configuration)
* [Features and products](#features-and-products)
* [User behavior](#user-behavior)
* [Monitor your waiting room](#monitor-your-waiting-room)

***

## Configuration

### Can I display my waiting room page in another language?

Yes. For more details, refer to [Customize a waiting room](https://developers.cloudflare.com/waiting-room/how-to/customize-waiting-room/).

### Why does my waiting room look different than how I designed it?

If you have [customized your waiting room template](https://developers.cloudflare.com/waiting-room/how-to/customize-waiting-room):

1. Preview your template before deploying it to production.
2. If you encounter any issues, check for proper syntax and a closing backslash (/).

Note

Only Enterprise customers can customize the appearance of their waiting room.

### What can I update when my waiting room is actively queueing?

You can update a [waiting room's template](https://developers.cloudflare.com/waiting-room/how-to/customize-waiting-room) and those changes will be visible to users in near-real time. We recommend these updates as a way to engage with users and provide updated information or expectations.

You can also update the [configuration settings](https://developers.cloudflare.com/waiting-room/reference/configuration-settings) of a waiting room, but only make these changes when necessary. These changes may impact the estimated wait time shown to end users and cause unnecessary confusion.

## Features and products

### Which features are included in my Waiting Room plan?

To check which features are available to different plan types, refer to [Plans](https://developers.cloudflare.com/waiting-room/plans/).

### How does Waiting Room interact with other Cloudflare products?

Some Cloudflare products run before a waiting room acts on traffic:

* DDoS Mitigation
* Web Application Firewall (WAF)
* Bot Management
* Page Rules

Other Cloudflare products run after a waiting room acts on traffic:

* Workers

## User behavior

### What happens if a user refreshes their tab when in a waiting room?

A manual tab refresh has no effect on a user's position in your waiting room.

However, if they close their tab and then try to access the application again during active queueing, they will lose their spot and have to go to the back of the queue.

### What happens if a queued user leaves the queue?

When a user joins the queue, they are placed into a bucket which is their general position in line. When a user leaves the queue (closes the browser or tab), their place in line is held for five minutes after the last refresh. This grace period allows users to keep their position in line if they experience a brief disconnection. After five minutes, the grace period expires and they are no longer counted as waiting in the queue.

## Monitor your waiting room

### Why do I observe a few users being queued in the dashboard?

Some users might be queued before your waiting room reaches is limit due to architectural designs. For more details on the behavior and how to fix it, refer to [​​Queueing activation](https://developers.cloudflare.com/waiting-room/how-to/monitor-waiting-room#queueing-activation).

### Why are some users not being queued in my waiting room?

If you notice users not being queued to your waiting room, make sure the path you defined exactly matches the path of your website.

The path is case-sensitive, so if you have a waiting room set up for `/Black-Friday-Sale` and users go to `/black-friday-sale`, they will bypass your waiting room.

For more details, refer to [Best practices](https://developers.cloudflare.com/waiting-room/reference/best-practices).

### Why are users being blocked from entering my waiting room?

If you have Rate Limiting, check your [rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/).

The Waiting Room queue page refreshes every 20 seconds by populating the refresh header. If you have a rule set to block requests from a specific IP within 20 seconds, the user in the waiting room will be blocked. Make sure your rules allow at least one request every 20 seconds.

Your user also might not have [cookies](https://developers.cloudflare.com/waiting-room/reference/waiting-room-cookie) enabled. If they do not enable cookies and your waiting room is actively queueing traffic, they will not reach your endpoint until the queueing stops.

### Why is the estimated wait time increasing for some users?

Estimated wait times may increase if the rate of users leaving your site decreases. The estimated wait time is updated upon each page refresh based on the most recently available information about the rate of slots opening up on your site and the number of users ahead of the user in line. To make this increase less likely, you could limit the amount of time users are allowed to spend on your site by disabling session renewal. Be aware that, if you change your traffic settings, estimated wait times will change as well.

### Why is `new users per minute` low when there is capacity available?

The `new users per minute` metric tracks how many users were accepted to the origin in the last minute. It is only incremented when a queued user refreshes and is accepted to the origin. If the waiting room queueing method is set to `fifo`, we will wait until all queued users in a minute-based bucket are accepted before moving to the next bucket. If many of the users in a bucket have abandoned the queue, then the waiting room must wait until their place in line expires before moving on to the next bucket. This can cause `new users per minute` to be low when only a small percentage of queued users are actually still waiting.

This is often noticed if there is a large amount of automated traffic which does not handle cookies properly. Since bots usually do not persist cookies from one request to the next, they end up counting as multiple inactive users in the queue and prevent full utilization of available slots. For this reason, we recommend leveraging [Bots Management](https://developers.cloudflare.com/bots/) products to keep bots out of the queue. Waiting Room Advanced customers can try our [Turnstile](https://developers.cloudflare.com/turnstile/) integration, which prevents bots from clogging the line by putting them in an infinite queue.

### Why are my Waiting Room analytics and Google analytics not matching?

Waiting Room relies on a session cookie to count and keep track of active users. The duration for which a user is considered active depends on the waiting room configuration. The key setting involved in this calculation is [session duration](https://developers.cloudflare.com/waiting-room/reference/configuration-settings/#session-duration). By default, Waiting Room considers a user active from the time of their last request made with a session cookie, until the configured session duration elapses. Customers with an advanced Waiting Room setup can modify this behavior by [disabling session renewal](https://developers.cloudflare.com/waiting-room/how-to/control-user-session/#disable-session-renewal-to-limit-browsing-time) and/or explicitly [revoking sessions](https://developers.cloudflare.com/waiting-room/how-to/control-user-session/#revoke-a-users-session-using-origin-commands) using an origin command.

If the session duration is set to a higher value, a user who makes only a single request will be considered active for longer than they actually were. This can cause the `Total Active Users` metric to appear higher than the active users metric reported by Google Analytics for the same time period, as Google Analytics only counts users who made requests during that specific period.

For example, if the session duration is set to 30 minutes and you look at the last 10 minutes of active users in Google Analytics, the number of active users reported by Waiting Room will be higher, since it includes users from the last 30 minutes.

Another key difference is that Waiting Room runs on requests made to the origin, while Google Analytics requires a user-agent to run JavaScript (via Google Tag). Waiting Room creates new sessions and tracks user metrics based on the HTTP request path, without requiring any additional JavaScript execution by a user-agent. In contrast, Google Analytics requires user-agents to execute JavaScript and make a secondary request to report details to Google Analytics. If a large portion of the traffic is automated, it may not be captured by Google Analytics. However, Waiting Room analytics will count such traffic as new users and consider them active for the configured session duration.

### Why did my traffic exceed the New Users Per Minute threshold?

Waiting Room is a distributed system, and achieving perfect global counting in real time is challenging due to the time required for state propagation across data centers worldwide. The budgeting logic is structured around both data center-specific and global budgets. Data center budgets are allocated based on the historical traffic received by each data center, while global budgets (a portion of the total available budget) are maintained to allow new users to enter from any data center globally.

In the case of a rapid spike — rising to several thousand users within a minute — the global state propagation process takes approximately two minutes, resulting in a delay before all data centers become aware of the spike. If this information is not disseminated quickly enough to other locations, temporary overshooting may occur, particularly when lower limits are in place.

This occurs because the portion of the budget reserved for new users to enter a data center is equally available to all data centers. Until the usage of this budget is synchronized across all data centers, each data center may consume a portion that collectively exceeds 100% of the global budget allocated for new users.
