---
title: Using Google Analytics with Cloudflare · Cloudflare Fundamentals docs
description: Using Cloudflare does not affect Google Analytics (GA) tracking if
  it is added to the website in one of ways recommended by Google.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/reference/google-analytics/
  md: https://developers.cloudflare.com/fundamentals/reference/google-analytics/index.md
---

Using Cloudflare does not affect Google Analytics (GA) tracking if it is added to the website [in one of ways recommended by Google](https://support.google.com/analytics/answer/9304153#add-tag).

## Standard GA setup

Cloudflare proxies traffic to your origin web server, but the GA JavaScript code never actually sends traffic to your server. Instead, it executes directly in a user's browser and does not interact with Cloudflare.

Cloudflare only affects analytics tools that read logs directly from your web server (like awstats).

Note

To troubleshoot potential issues with Google Analytics, refer to [Common GA setup mistakes](https://support.google.com/analytics/answer/1009683).

## Zaraz

As an alternative to the standard setup of Google Analytics with tag/snippet, Cloudflare offers a way to use Google Analytics with [Zaraz](https://developers.cloudflare.com/zaraz/). Zaraz is a solution that allows Google Analytics to collect data without its script loaded on the website. If GA is set up this way, then not all features may be available.

Note

Details about features of Google Analytics that are unavailable with Zaraz can be found in [Zaraz FAQ](https://developers.cloudflare.com/zaraz/faq/#tools)
