---
title: Create private networks with WARP-to-WARP · Cloudflare One docs
description: With Cloudflare Zero Trust, you can create a private network
  between any two or more devices running Cloudflare WARP. This means that you
  can have a private network between your phone and laptop without ever needing
  to be connected to the same physical network. If you already have an existing
  Zero Trust deployment, you can also enable this feature to add
  device-to-device connectivity to your private network with the press of a
  button. This will allow you to connect to any service that relies on TCP, UDP,
  or ICMP-based protocols through Cloudflare's network.
lastUpdated: 2025-11-03T22:57:16.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-to-warp/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/warp-to-warp/index.md
---

With Cloudflare Zero Trust, you can create a private network between any two or more devices running Cloudflare WARP. This means that you can have a private network between your phone and laptop without ever needing to be connected to the same physical network. If you already have an existing Zero Trust deployment, you can also enable this feature to add device-to-device connectivity to your private network with the press of a button. This will allow you to connect to any service that relies on TCP, UDP, or ICMP-based protocols through Cloudflare's network.

Users in your organization can reach these services by enrolling into your organization's Zero Trust account. Once enrolled, each device is assigned a virtual IP address in the `100.96.0.0/12` range which will allow users or systems to address these devices directly. Administrators will then be able to build Zero Trust policies to determine who within your organization can reach those virtual IPs.

This guide covers how to:

* Enable WARP-to-WARP connectivity to establish a private network between your devices.
* Manage Split Tunnel preferences for the WARP client to determine what traffic should be routed to the Cloudflare global network.
* Create Zero Trust security policies to restrict access.
* Connect to virtual IP spaces from WARP devices without any client-side configuration changes.

## Prerequisites

* [Install the Cloudflare WARP client](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/) on your devices.
* [Define device enrollment permissions](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/device-enrollment/).
* [Enroll your devices](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/manual-deployment/) in your Zero Trust organization.

## Enable WARP-to-WARP

1. In [Cloudflare One](https://one.dash.cloudflare.com), go to **Team & Resources** > **Devices** > **Management**.

2. Select **Peer to peer connectivity**.

3. Enable **Allow WARP to WARP connection**. This allows Cloudflare to route traffic to the CGNAT IP space.

4. In your [Split Tunnel configuration](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/), ensure that traffic to `100.96.0.0/12` is going through WARP:

   * Exclude IPs and domains

     If using Split Tunnels in **Exclude** mode:

     1. Delete `100.64.0.0/10` from the list.

     2. We recommend [adding back the IPs](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/connect-cidr/#3-route-private-network-ips-through-warp) that are not being used for Zero Trust services. For example, if you are using WARP-to-WARP alongside [Gateway host selectors](https://developers.cloudflare.com/cloudflare-one/traffic-policies/egress-policies/host-selectors/) or [private hostname routing](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/connect-private-hostname/), add routes to exclude the following IP addresses:

        * `100.64.0.0/12`
        * `100.81.0.0/16`
        * `100.82.0.0/15`
        * `100.84.0.0/14`
        * `100.88.0.0/13`
        * `100.112.0.0/12`

   * Include IPs and domains

     If using Split Tunnels in **Include** mode:

     1. Add the required [Zero Trust domains](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/#cloudflare-zero-trust-domains) or [IP addresses](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/#cloudflare-zero-trust-ip-addresses) to your Split Tunnel include list.
     2. [Add a route](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/#add-a-route) to include `100.96.0.0/12`.

This will instruct WARP to begin proxying any traffic destined for a `100.96.0.0/12` IP address to Cloudflare for routing and policy enforcement.

## Connect via WARP

Once enrolled, your users and services will be able to connect to the virtual IPs configured for TCP, UDP, or ICMP-based traffic. You can optionally create [Gateway network policies](https://developers.cloudflare.com/cloudflare-one/traffic-policies/network-policies/) to define the users and devices that can access the `100.96.0.0/12` IP space.

## Troubleshooting

### Check your firewall

Verify that your local firewall allows traffic from the WARP CGNAT IPs. For example, Windows Firewall blocks inbound traffic from `100.96.0.0/12` by default. On Windows devices, you will need to add a firewall rule that allows incoming requests from `100.96.0.0/12` for the desired protocols and/or ports.
