---
title: Enable cache in an R2 bucket · Cloudflare Cache (CDN) docs
description: "To enable caching for a Cloudflare R2 bucket, make sure your
  bucket is public and accessible by the Cache. This can be done by creating a
  Custom Domain. Follow these steps to set up a Custom Domain for your bucket:"
lastUpdated: 2025-04-15T08:21:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cache/interaction-cloudflare-products/r2/
  md: https://developers.cloudflare.com/cache/interaction-cloudflare-products/r2/index.md
---

To enable caching for a [Cloudflare R2](https://developers.cloudflare.com/r2/) bucket, make sure your bucket is public and accessible by the Cache. This can be done by creating a [Custom Domain](https://developers.cloudflare.com/r2/buckets/public-buckets/#custom-domains). Follow these steps to set up a Custom Domain for your bucket:

1. Go to **R2** and select your bucket.
2. On the bucket page, select **Settings**.
3. Under **Public access** > **Custom Domains**, select **Connect Domain**.
4. Enter the domain name you want to connect to and select **Continue**.
5. Review the new record that will be added to the DNS table and select **Connect Domain**.

This will generate a publicly available CNAME in the format `[name].domain.com`.

## Tiered Cache

By default Cloudflare will cache R2 content based on [cache rules](https://developers.cloudflare.com/cache/how-to/cache-rules/) at the Edge only.

Tiered cache can be enabled by configuring [Smart Tiered Cache](https://developers.cloudflare.com/cache/how-to/tiered-cache/#smart-tiered-cache) which will select an Upper Tier data center next to your R2 bucket for optimal performance.

## Additional considerations

* Apply access controls to your newly public bucket. Refer to [Control cache access with WAF and Snippets](https://developers.cloudflare.com/cache/interaction-cloudflare-products/waf-snippets/) for more information.
* Be aware of the [cacheable size limits](https://developers.cloudflare.com/cache/concepts/default-cache-behavior/#cacheable-size-limits) for files.
